function I = GLQ(fun,a,b,nnode)
% GLQ  Single Gauss-Legendre quadrature
%
% Synopsis:  I = GLQ(fun,a,b,nnode)
%
% Input:  fun    = (string) name of m-file that evaluates f(x)
%         a,b    = lower and upper limits of the integral
%         nnode = number of nodes in interval [a,b]
%
% Output: I = approximate value of the integral from a to b of f(x)*dx

if nnode<=8
  [z,wt] = GLTable(nnode);           %  Look up nodes and weights,
else                                 %  or if n is too big for the table,
  [z,wt] = GLNodeWt(nnode);          %  compute the nodes and weights
end
I = 0;                               %  Initialize sum
for i=1:nnode
    y=((b-a)*z(i)+a+b)/2;            % transform nodes to [a,b] interval 
    f = feval(fun,y);
  I = I + sum(wt(i).*f);             %  Add contribution of this node
end
I = (b-a)*I/2;                       %  Factor of H/2 to transform to [a.b]
